Include "col_mesh_lib.bb"
Const Rigid_Bodies=10,Animated_Bodies=5,Rigid_Particles=0

TOKSIM_SetRigidBodiesCount Rigid_Bodies
TOKSIM_SetAnimatedBodiesCount Animated_Bodies
TOKSIM_SetRigidParticleCount Rigid_Particles
TOKSIM_SetControllersCount 0
TOKSIM_SetGeometriesCount Rigid_bodies+Animated_Bodies

;TOKSIM_SetCollisionResponse (0,1,0)

TOKSIM_CreateSimulator(0,-4,0)

Global MaxX = 1024, MaxY = 768
Graphics3D MaxX,MaxY,32,2

Global fps_anzeige
Global fps_ms=MilliSecs()
Global fps_frames
Global RR,Turbo#,Turbo_ms = MilliSecs()
Global PosX#,PosY#,PosZ#
Global mz#,my#,speed#,rutsch,mfy#=0.1
Global time = MilliSecs()
Global col

TOKSIM_SetMaterial 1,0.9,1.0 ; Boden
TOKSIM_SetMaterial 2,0.5,0.7 ; spin

;-------------------------------------------------------------------------------
; Boden initialisieren
;-------------------------------------------------------------------------------
Global tex=CreateTexture(256,256)

SetBuffer Texturebuffer(tex)
ClsColor 35,135,35
Cls
For x = 0 To 127
		For y = 0 To 127
		    Color 0,100,0
		    Rect x,y,1,1
		Next
Next
SetBuffer BackBuffer()
  MoveMouse MaxX/2,MaxY/2

Global boden=CreateTerrain(128)
;EntityType boden,2
EntityTexture boden,tex
EntityColor boden,35,135,35
;PositionEntity boden,-2,0,-2
abground = TOKAB_Create()
geom = TOKAB_AddBox(abground,128.0,0.2,128.0)
TOKAB_SetPosition(abground,64,0,64)
TOKAB_SetCollisionID(abground,0)
TOKGEOM_SetMaterialIndex geom,1
;-------------------------------------------------------------------------------
; Figur/Kegel initialisieren
;-------------------------------------------------------------------------------
Dim obj(Rigid_Bodies)
Dim rb(Rigid_Bodies)

i=1
ry# = 0.185
Global spin = LoadMesh("Gfx/kegel2.3ds")
EntityType spin,1
EntityRadius spin,ry#
;PositionEntity spin,0,1.5,1.5

rb_spin = TOKRB_Create()
geom1 =TOKRB_Addsphere (rb_spin,0.2)
TOKRB_SetPosition rb_spin,2,1.5,2.5
TOKRB_SetLinearDamping rb_spin,0.02
TOKRB_SetAngularDamping rb_spin,0.01
TOKRB_SetMass rb_spin,0.8
TOKRB_SetsphereInertiaTensor rb_spin,0.2,0.8
TOKRB_SetCollisionID(spin,1)
TOKGEOM_SetMaterialIndex geom1,2
TOKRB_UpdateBoundingInfo(rb_spin)
;-------------------------------------------------------------------------------
; Rampe/Podest/Fahrstuhl/Treppe initialisieren
;-------------------------------------------------------------------------------
Global rampe = LoadMesh("Gfx/rampe.3ds")
EntityType rampe,2
PositionEntity rampe,10,1,15.5
;abrampe = TOKAB_Create()
geom2 = TOK_AddMesh(rampe,0,-1,0)
;TOKAB_SetPosition(abrampe,10,1.0,15.5)
;TOKAB_SetCollisionID(abrampe,0)
TOKGEOM_SetMaterialIndex geom2,1
TOKSIM_SetStaticMesh(Vertices,0,Triangles,0)
Global podest = LoadMesh("Gfx/podest.3ds")
EntityType podest ,2
PositionEntity podest ,10,1,5.5

Global fahrstuhl = LoadMesh("Gfx/fahrstuhl.3ds")
EntityType fahrstuhl ,33
EntityRadius fahrstuhl,20.25
;PositionEntity fahrstuhl ,0,0.0,1.5
PositionEntity fahrstuhl ,6.75,0.1,5.5
rb_fahr = TOKRB_Create()
geom3 =TOKRB_Addbox (rb_fahr,1.0,1.2,1.0)
TOKRB_SetPosition rb_fahr,6.75,0.1,5.5
TOKRB_SetLinearDamping rb_fahr,0.02
TOKRB_SetAngularDamping rb_fahr,0.01
TOKRB_SetMass rb_fahr,0.8
TOKRB_SetboxInertiaTensor rb_fahr,1.0,1.2,1.0,0.8
TOKRB_SetCollisionID(fahrstuhl,1)
TOKGEOM_SetMaterialIndex geom1,2
TOKRB_UpdateBoundingInfo(rb_fahr)

Global stopp = LoadMesh("Gfx/stop.3ds")
EntityType stopp,2
PositionEntity stopp ,6.75,0.0,5.5
;-------------------------------------------------------------------------------
; Kristalle initialisieren
;-------------------------------------------------------------------------------
Global kristall = LoadMesh("Gfx/kristall.3ds")
EntityType kristall,2
EntityRadius kristall,0.1
PositionEntity kristall,15,2.1,18.5

Global kristall2 = LoadMesh("Gfx/kristall.3ds")
EntityType kristall2,2
EntityRadius kristall2,0.1
PositionEntity kristall2,10,2.1,5.5
;-------------------------------------------------------------------------------
; Kamera initialisieren
;-------------------------------------------------------------------------------
cx# = 15.0 : cy# = 0.55 : cz# = -1.8
Global cam = CreateCamera(spin)
;RotateEntity cam,15,0,0
CameraClsColor cam,82,132,181
PositionEntity cam, cx#,cy#,cz#
CameraZoom cam,3
;-------------------------------------------------------------------------------
; Licht initialisieren
;-------------------------------------------------------------------------------
light=CREATELIGHT(0.8,spin)
RotateEntity Light,25,45,0

HidePointer
;-------------------------------------------------------------------------------
; Hauptschleife
;-------------------------------------------------------------------------------
Repeat
	time = MilliSecs()
	a = 0

  ty#   = 0.0                   ; geradeaus

  PosX# = EntityX#(spin)
  PosY# = EntityY#(spin)
  PosZ# = EntityZ#(spin)

  KD200 = KeyDown(200)          ; vorwrts
  KD208 = KeyDown(208)          ; rckwrts
  KD203 = KeyDown(203)          ; links
  KD205 = KeyDown(205)          ; rechts
  KD199 = KeyDown(199)          ; Pos1 = Zoom in
  KD207 = KeyDown(207)          ; Ende = Zoom out

  KH210 = KeyHit(210)           ; Einfg= Ansicht zentrieren
  KH57  = KeyHit(57)            ; space = springen
  KH48  = KeyHit(48)            ; B = bremsen
  KH20  = KeyHit(20)            ; T = Turbo

; Maussteuerung Anfang ---------------------------------------------------------

  mxs   = MouseXSpeed()
  mys   = MouseYSpeed()

  cx#   = EntityPitch(cam) + mys*0.2
  sy#   = EntityYaw(spin)  - mxs*0.2

  If cx# > +25 Then cx# = +25
  If cx# < -89 Then cx# = -89

  RotateEntity cam,cx#,0,0
  MoveMouse MaxX/2,MaxY/2

; Maussteuerung Ende -----------------------------------------------------------
; Tastatursteuerung Anfang -----------------------------------------------------

  If KD203 ty# = +1.0           			; links drehen
  If KD205 ty# = -1.0           			; rechts drehen

  If KH57 And EntityY#(spin) < 0.3 Then jump = 1         			; springen


  If KD200 Then RR = +1 : mz# = +0.04 : B = 0 ; vorwrts
  If KD208 Then RR = -1 : mz# = -0.04 : B = 0 ; rckwrts
  If KH48  And  B  = 0 Then                     ; bremsen
		 RR =  0
		 PosXsave# = EntityX#(spin)
  	 PosZsave# = EntityZ#(spin)
  	 B = 1
	EndIf

  If KH20  Then turbo# = 0.06

  If KD199 Then cy# = cy# - 0.05 : cz# = cz# + 0.1    ; zoom in
  If KD207 Then cy# = cy# + 0.05 : cz# = cz# - 0.1    ; zoom out

  If cy# < +0.5 Then cy# = +0.5                       ; Begrenzung
	If cy# > +4.0 Then cy# = +4.0                       ; fr
  If cz# > -1.5 Then cz# = -1.5                       ; Kamera -
	If cz# < -8.5 Then cz# = -8.5                       ; Zoom

  If KH210 Then cy# = 0.75 : cz# = -2.0               ; Sicht zentrieren

  PositionEntity cam, 0,cy#,cz#                       ; Kamera einstellen

; Tastatursteuerung Ende -------------------------------------------------------



; Trgheit (rutschen und beschleunigen) Anfang ---------------------------------

;	If RR <> 0 Then                     ; Wenn Taste gedrckt
;	   mz# = mz# +(0.0015*RR) : RR = 0  ; beschleunigen
;		 If mz# > +0.08 Then mz# = +0.08  ; Max speed +
;		 If mz# < -0.08 Then mz# = -0.08  ; Max speed -
;  End If
;
; Trgheit (rutschen und beschleunigen) Ende -----------------------------------

	RotateMesh spin, 0,13,0        ; Rotation spin

	speed# = mz# + Turbo#

	col = CountCollisions(spin)

; Tokamak Anfang --------------------------------------------------------------

	VerschX# = cos#(90+(ENTITYYAW#(cam,1)))*speed#
	VerschZ# = sin#(90+(ENTITYYAW#(cam,1)))*speed#

	CaptureWorld

		PositionEntity spin,TOKRB_GetX#(rb_spin),TOKRB_GetY#(rb_spin),TOKRB_GetZ#(rb_spin)
		RotateEntity spin,TOKRB_GetPitch#(rb_spin),TOKRB_GetYaw#(rb_spin),TOKRB_GetRoll#(rb_spin),False

		;TOKRB_SetRotation rb_spin,TOKRB_GetPitch#(rb_spin),TOKRB_GetYaw#(rb_spin)+sy#,TOKRB_GetRoll#(rb_spin)
		;TOKRB_SetPosition rb_spin,TOKRB_GetX#(rb_spin)+VerschX#,TOKRB_GetY#(rb_spin),TOKRB_GetZ#(rb_spin)+VerschZ#

  	If RR <> 0 Then TOKRB_ApplyImpulse rb_spin,VerschX#,0,VerschZ#

  	If B = 1 Then TOKRB_SetPosition rb_spin,PosXsave#,TOKRB_GetY#(rb_spin),PosZsave# :TOKRB_UpdateBoundingInfo(rb_spin)
  
		If jump Then
   		 TOKRB_ApplyImpulse rb_spin,0,3.0,0
   		 jump = 0
		EndIf

;  	If TOKRB_GetY#(rb_fahr) <= +1.97 Then mfy# = +0.01
;		If TOKRB_GetY#(rb_fahr) >= -0.03 Then mfy# = -0.01
		TOKRB_ApplyImpulse rb_fahr ,0,mfy#,0

		If PosY# < -10.0 Then
			 TOKRB_SetPosition rb_spin,2.0,1.5,2.5 : B = 1
		EndIf

	TOKSIM_Advance(1.5/60,1)

; Tokamak Ende ----------------------------------------------------------------

	TurnEntity spin, 0,ty#,0
	RotateEntity spin,0,sy#,0,1

  Collisions 1,2,2,2                    ; Kollision zw. Kegel und Map

	RR = 0
	UpdateWorld
	RenderWorld

  Color 0,0,0
  Text 10,40,"Yaw: "+ENTITYYAW#(cam,1)+" Turbo: "+Turbo+" Speed: "+speed#+" Col: "+col+"Kristalle: "+kristalle,0,1
  Text 10,55,"Positionen: X = "+Posx+" Y: "+Posy+" Z: "+PosZ+" "+bum2,0,1;+Entityy#(fahrstuhl);+" "+Entityy#(podest),0,1
  Text 10,25,"cx: "+cx#+"cy#: "+cy#+" cz#: "+cz#+" FF: "+FF+" RR: "+RR+" Rutsch: "+rutsch+" sin: "+VerschX#+" cos: "+VerschY#,0,1

	While MilliSecs() < time + 13
	  a = a + 1
  Wend
  Fps()
  Text 10,10,"FPS: "+fps_anzeige+" my#="+my#+" a: "+a+" pitch: "+Entitypitch#(cam)+" mfy: "+mfy#+" "+TOKRB_GetY#(rb_fahr),0,1

Flip 0
Until KeyHit(1)
TOKSIM_DestroySimulator()
End
;-------------------------------------------------------------------------------
; Hauptschleife Ende
;-------------------------------------------------------------------------------
;*******************************************************************************
;-------------------------------------------------------------------------------
; Funktion FPS
;-------------------------------------------------------------------------------
Function Fps()

	fps_frames = fps_frames + 1

	If MilliSecs() - fps_ms >= 1000 Then
		 fps_anzeige = fps_frames
		 fps_frames  = 0
		 fps_ms = MilliSecs()
  End If

End Function

